import { BuildHook, IBuildResult, ITaskOptions } from '../@types';
import { PACKAGE_NAME } from './global';
import * as path from 'path';
import * as fs from 'fs';

function log(...arg: any[]) {
    return console.log(`[${PACKAGE_NAME}] `, ...arg);
}

let allAssets = [];

export const throwError: BuildHook.throwError = true;

export const load: BuildHook.load = async function() {
    console.log(`[${PACKAGE_NAME}] Load cocos plugin example in builder.`);
    allAssets = await Editor.Message.request('asset-db', 'query-assets');
};

export const onBeforeBuild: BuildHook.onBeforeBuild = async function(options: ITaskOptions, result: IBuildResult) {
};

export const onBeforeCompressSettings: BuildHook.onBeforeCompressSettings = async function(options: ITaskOptions, result: IBuildResult) {
};

export const onAfterCompressSettings: BuildHook.onAfterCompressSettings = async function(options: ITaskOptions, result: IBuildResult) {
};

export const onAfterBuild: BuildHook.onAfterBuild = async function (options: ITaskOptions, result: IBuildResult) {
    console.log("onAfterBuild", "options:", JSON.stringify(options));

    if (options.platform === "android") {
        const libsPath = path.join(Editor.Project.path, 'native', 'engine', 'android', 'app', 'libs');
        if (!fs.existsSync(libsPath)) {
            fs.mkdirSync(libsPath, { recursive: true });
        }

        const aarSrc = path.join(__dirname, '..', 'native', 'android', 'nexverseplugin.aar');
        const aarDest = path.join(libsPath, 'nexverseplugin.aar');

        if (fs.existsSync(aarSrc)) {
            fs.copyFileSync(aarSrc, aarDest);
            console.log(`Nexverse Copied nexverseplugin.aar to ${aarDest}`);
        } else {
            console.warn(`Nexverse nexverseplugin.aar not found at ${aarSrc}`);
        }
    }

    if (options.platform === "ios") {
        const destPath = path.join(Editor.Project.path, 'native', 'engine', 'ios', 'NexverseAdBridge');
        if (!fs.existsSync(destPath)) {
            fs.mkdirSync(destPath, { recursive: true });
        }

        const srcPath = path.join(__dirname, '..', 'native', 'ios');
        const entries = fs.readdirSync(srcPath, { withFileTypes: true });
        for (const entry of entries) {
            const src = path.join(srcPath, entry.name);
            const dest = path.join(destPath, entry.name);

            fs.copyFileSync(src, dest);
            console.log(`Nexverse Copied ${entry.name} to ${dest}`);
        }
    }
};

export const unload: BuildHook.unload = async function() {
    console.log(`[${PACKAGE_NAME}] Unload cocos plugin example in builder.`);
};

export const onError: BuildHook.onError = async function(options, result) {
    // Todo some thing
    console.warn(`${PACKAGE_NAME} run onError`);
};

export const onBeforeMake: BuildHook.onBeforeMake = async function(root, options) {
    console.log(`onBeforeMake: root: ${root}, options: ${options}`);
};

export const onAfterMake: BuildHook.onAfterMake = async function(root, options) {
    console.log(`onAfterMake: root: ${root}, options: ${options}`);
};
