#import "BannerHandler.h"
#import "NexverseAdBridge.h"
@import Nexverse;

@interface BannerHandler ()
@property (nonatomic, strong) BannerView *bannerView;

@end

@implementation BannerHandler

- (void)load:(NSString *)configId width:(int)width height:(int)height placement:(int)placement autoRefresh:(int)autoRefresh video:(Boolean)video
{
    CGSize adSize = CGSizeMake(MAX(1, width), MAX(1, height));
    CGRect frame = CGRectMake(0, 0, adSize.width, adSize.height);
    
    self.bannerView = [[BannerView alloc] initWithFrame:CGRectZero configID:configId adSize:adSize bidFloor:NULL];

    // 2. Configure the BannerView
    self.bannerView.delegate = self;
    self.bannerView.videoEventsDelegate = self;
    self.bannerView.videoParameters.placement = PBPlacement.InBanner;
    self.bannerView.redirectionType = RedirectionTypeExternalBrowser;
    
    if(video)
        self.bannerView.adFormat = AdFormat.video;
    else
        self.bannerView.adFormat = AdFormat.banner;

    UIViewController *rootVC = [UIApplication sharedApplication].keyWindow.rootViewController;
    [self.bannerView removeFromSuperview];
    self.bannerView.translatesAutoresizingMaskIntoConstraints = NO;
    [rootVC.view addSubview:self.bannerView];

    UILayoutGuide *safeArea = rootVC.view.safeAreaLayoutGuide;
    [NSLayoutConstraint activateConstraints:@[
        [self.bannerView.centerXAnchor constraintEqualToAnchor:safeArea.centerXAnchor],
        [self.bannerView.bottomAnchor constraintEqualToAnchor:safeArea.bottomAnchor],
        [self.bannerView.widthAnchor constraintEqualToConstant:320],
        [self.bannerView.heightAnchor constraintEqualToConstant:50]
    ]];

    // 3. Load the banner ad
    [self.bannerView loadAd];
}

- (void)destroy {
    if(self.bannerView)
        [self.bannerView removeFromSuperview];
}

// MARK: - BannerViewDelegate
- (UIViewController * _Nullable)bannerViewPresentationController {
    return self;
}
- (void)bannerView:(BannerView *)bannerView didReceiveAdWithAdSize:(CGSize)adSize {
    [[NexverseAdBridge sharedInstance] sendEvent:@"OnBannerLoaded" data:@""];
}

- (void)bannerView:(BannerView *)bannerView didFailToReceiveAdWith:(NSError *)error {
    [[NexverseAdBridge sharedInstance] sendEvent:@"OnBannerFailed" data:error.description];
}

- (void)bannerViewWillLeaveApplication:(BannerView *)bannerView {
    // Handle app leaving foreground
}

- (void)bannerViewWillPresentModal:(BannerView *)bannerView {
    [[NexverseAdBridge sharedInstance] sendEvent:@"OnBannerDisplayed" data:@""];
}

- (void)bannerViewDidDismissModal:(BannerView *)bannerView {
    [[NexverseAdBridge sharedInstance] sendEvent:@"OnBannerDestroyed" data:@""];
}


// MARK: - NexverseVideoEventsDelegate
- (void)onVideoStart {
    // Video started
}

- (void)onVideoFirstQuartile {
    // Video played till first quartile
}

- (void)onVideoMidpoint {
    // Video played till mid point
}

- (void)onVideoThirdQuartile {
    // Video played till third quartile
}

- (void)onVideoComplete {
    [[NexverseAdBridge sharedInstance] sendEvent:@"BannerVideoCompleted" data:@""];
}

- (void)onVideoPause {
    [[NexverseAdBridge sharedInstance] sendEvent:@"BannerVideoPaused" data:@""];
}

- (void)onVideoResume {
    [[NexverseAdBridge sharedInstance] sendEvent:@"BannerVideoResumed" data:@""];
}

- (void)onVideoMute {
    [[NexverseAdBridge sharedInstance] sendEvent:@"BannerVideoMuted" data:@""];
}

- (void)onVideoUnmute {
    [[NexverseAdBridge sharedInstance] sendEvent:@"BannerVideoUnMuted" data:@""];
}

- (void)onVideoProgressWithCurrentTime:(NSTimeInterval)currentTime
                              duration:(NSTimeInterval)duration {
    // Video playback time changed to currentTime
}

- (void)onVideoReplay {
    // Replay button tapped
}

- (void)onVideoError:(NSError * _Nullable)error {
    [[NexverseAdBridge sharedInstance] sendEvent:@"OnBannerFailed" data:error.description];
}

@end
