export enum BannerPlacement
{
    // Basic values
    Left = 0x03,
    Right = 0x05,
    Top = 0x30,
    Bottom = 0x50,
    CenterHorizontal = 0x01,
    CenterVertical = 0x10,
    Start = 0x800003,
    End = 0x800005,

    // Composite values (combinations of the above)
    Center = CenterHorizontal | CenterVertical, // 0x11
    FillHorizontal = Left | Right,             // 0x07
    FillVertical = Top | Bottom,               // 0x70
    Fill = FillHorizontal | FillVertical,      // 0x77

    // You can add other combinations as needed
    TopLeft = Top | Left,
    BottomCenter = Bottom | CenterHorizontal
}