/*   Copyright 2025 Nexverse

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "PBMOpenMeasurementFriendlyObstructionPurpose.h"

@class OMIDVersein4AdSessionContext;
@class OMIDVersein4AdSessionConfiguration;
@class PBMVideoVerificationParameters;
@protocol PBMEventTrackerProtocol;

NS_ASSUME_NONNULL_BEGIN
@interface PBMOpenMeasurementSession : NSObject

@property (nonatomic, readonly) id<PBMEventTrackerProtocol> eventTracker;

- (nonnull)initWithContext:(OMIDVersein4AdSessionContext *)context
             configuration:(OMIDVersein4AdSessionConfiguration *)configuration;

#pragma mark - PBMOpenMeasurementSessionProtocol

- (void)start;

- (void)stop;

- (void)addFriendlyObstruction:(UIView *)friendlyObstruction purpose:(PBMOpenMeasurementFriendlyObstructionPurpose)purpose;

#pragma mark - Methods

- (void)setupMainView:(UIView *)mainView;


@end
NS_ASSUME_NONNULL_END
