/*   Copyright 2025 Nexverse

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

#import <Foundation/Foundation.h>

// This protocol allows the VideoView to communicate events out to whatever is using one
NS_ASSUME_NONNULL_BEGIN
@protocol PBMVideoViewDelegate <NSObject>

- (void)videoViewFailedWithError:(NSError *)error;

- (void)videoViewReadyToDisplay;
- (void)videoViewCompletedDisplay;
- (void)videoViewWasTapped;

- (void)videoViewCurrentPlayingTime:(NSNumber *)currentPlayingTime;
- (void)videoViewCurrentRemainingTime:(NSNumber *)remainingTime;

- (void)learnMoreWasClicked;
- (void)stopOmSession;

@end
NS_ASSUME_NONNULL_END
