/*   Copyright 2025 Nexverse

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

#import "PBMORTBAbstract.h"

@class PBMORTBBidExtNexverseCache;
@class PBMORTBExtNexversePassthrough;
@class PBMORTBExtNexverseEvents;

NS_ASSUME_NONNULL_BEGIN

@interface PBMORTBBidExtNexverse : PBMORTBAbstract

@property (nonatomic, strong, nullable) PBMORTBBidExtNexverseCache *cache;
@property (nonatomic, copy, nullable) NSDictionary<NSString *, NSString *> *targeting;
@property (nonatomic, copy, nullable) NSDictionary<NSString *, id> *meta;
@property (nonatomic, copy, nullable) NSString *type;
@property (nonatomic, copy, nullable) NSArray<PBMORTBExtNexversePassthrough *> *passthrough;
@property (nonatomic, strong, nullable) PBMORTBExtNexverseEvents *events;

@end

NS_ASSUME_NONNULL_END
